﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class NewsLettersBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static NewsLetters GetItem(Guid newsLettersID, string keyword)
        {
            return NewsLettersDB.GetItem(newsLettersID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<NewsLetters> GetList(Guid newsLettersID, string keyword)
        {
            return NewsLettersDB.GetList(newsLettersID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid newsLettersID, string keyword)
        {
            return NewsLettersDB.GetDataTable(newsLettersID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid newsLettersID, string keyword)
        {
            return NewsLettersDB.GetDataSet(newsLettersID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(NewsLetters myNewsLetters)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                NewsLettersDB.Save(myNewsLetters);

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
